/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Untar;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class TarUtil {
    public static IStatus extractTGZFile(IPath source, IPath destination) {
        File destinationFile = destination.toFile();
        File sourceFile = source.toFile();
        if (!"win32".equals(Platform.getOS())) {
            try {
                Process process = Runtime.getRuntime().exec(new String[]{"tar", "-C", destinationFile.getAbsolutePath(), "-xzf", sourceFile.getAbsolutePath()});
                process.waitFor();
            }
            catch (IOException e) {
                IdeLog.logWarning((Plugin)CorePlugin.getDefault(), "Error unpacking .tgz - " + source.toOSString(), e);
                return new Status(4, "com.aptana.core", "Error unpacking .tgz - " + source.toOSString(), (Throwable)e);
            }
            catch (InterruptedException e) {
                IdeLog.logWarning((Plugin)CorePlugin.getDefault(), e);
                return new Status(4, "com.aptana.core", "Error unpacking .tgz. Process interrupted.");
            }
        }
        Untar file = new Untar();
        Untar.UntarCompressionMethod method = new Untar.UntarCompressionMethod();
        method.setValue("gzip");
        file.setCompression(method);
        file.setDest(destinationFile);
        file.setSrc(sourceFile);
        try {
            file.execute();
        }
        catch (BuildException e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), "Error unpacking .tgz - " + source.toOSString(), e);
            return new Status(4, "com.aptana.core", "Error unpacking .tgz - " + source.toOSString(), (Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

